=begin
=娯楽/トランプ基本




==更新履歴
  Date     Version Author Comment

=end


#==============================================================================
# ■ Card
#==============================================================================
class Card
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  # id : 0~52を想定
  #--------------------------------------------------------------------------
  def initialize(id)
    @id = id
    @surface = false
  end
  #--------------------------------------------------------------------------
  # ● 番号の取得
  #    0-12 -> 2-A
  #--------------------------------------------------------------------------
  def number
    return @id % 13
  end
  #--------------------------------------------------------------------------
  # ● スートの取得
  #--------------------------------------------------------------------------
  def suit
    return @id / 13
  end
  #--------------------------------------------------------------------------
  # ● ジョーカー？
  #--------------------------------------------------------------------------
  def joker?
    return @id == 52
  end
  #--------------------------------------------------------------------------
  # ● 公開？
  #--------------------------------------------------------------------------
  def open?
    return @surface
  end  
  #--------------------------------------------------------------------------
  # ● 非公開？
  #--------------------------------------------------------------------------
  def close?
    return !@surface
  end  
  #--------------------------------------------------------------------------
  # ● 表面に変更
  #--------------------------------------------------------------------------
  def open
    @surface = true
  end  
  #--------------------------------------------------------------------------
  # ● 裏面に変更
  #--------------------------------------------------------------------------
  def close
    @surface = false
  end
  #--------------------------------------------------------------------------
  # ● 表裏反転
  #--------------------------------------------------------------------------
  def flip
    @surface = !@surface
  end
  #--------------------------------------------------------------------------
  # ● 性能評価
  #--------------------------------------------------------------------------
  def performance 
    a = joker? ? 100 : suit
    b = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 0].index(number)
    return (b * 4) + a
  end
end










